import asyncio
import pymysql
from ping3 import ping

# Connexion à la base de données
db = pymysql.connect(host='localhost', user='dash', password='0wlh1fr6r', database='DashBoard', port=8889)

# Créer un curseur
cursor = db.cursor()

# Récupérer la liste des adresses IP à surveiller depuis la base de données
cursor.execute("SELECT ip FROM peripherique")
servers = cursor.fetchall()

# Fermer le curseur et la connexion à la base de données
cursor.close()
db.close()

# Fonction pour effectuer le ping de manière asynchrone
async def ping_async(server_address):
    latency = ping(server_address)
    return server_address, latency

# Utiliser asyncio pour exécuter les pings de manière asynchrone
async def main():
    tasks = [ping_async(server[0]) for server in servers]
    results = await asyncio.gather(*tasks)
    
    latencies = {ip: latency for ip, latency in results}
    
    # Imprimer le dictionnaire de latences au format JSON
    import json
    latency_json = json.dumps(latencies)
    print(latency_json)

# Exécuter la boucle asyncio
if __name__ == "__main__":
    loop = asyncio.get_event_loop()
    loop.run_until_complete(main())
